function [mlfmt,N,ftfmt]=ftfmt2ml(ftfmt)
% [mlfmt,N,ftfmt]=ftfmt2ml(ftfmt);
% Translate fortran format to matlab format
% Example:
% [mlfmt,N,ftfmt]=ftfmt2ml('(8F7.2)');
% yields ['%7.2f',8,ftfmt]
% ftfmt is adepted so that it will have room for the required number of
% significant digits
% Other ftfmt examples are (20I4) (8E15.3) (9G10.3)
% TO 081231


% Copyright 2009 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later


ftfmt=strtrim(ftfmt); if ftfmt(1)=='(', ftfmt=ftfmt(2:end-1);  end
A=sscanf(ftfmt,'%d %c %d %c %d');

switch length(A)
    case {1 2}
        error(['Illegal fortran format: ',ftfmt]);
    case 3
        mlfmt=sprintf('%%%d%c%',   A(3),     lower(char(A(2)))); N=A(1);
    otherwise  % i.e. 5 args like 10E12.5
        A(2)=lower(char(A(2)));
        if A(2)=='e' || A(2)=='g',
            A(5)=min(A(3)-7,A(5));
            ftfmt=sprintf('%d%c%d%c%d',A);
        end
        mlfmt=sprintf('%%%d.%d%c', A(3),A(5),A(2)); N=A(1);
end

ftfmt=['(' ftfmt ')'];
